load x
load y
load u

t1=x(:,1);
pos1=1000*x(:,2:4);
u=1e-6*u;

t2=y(:,1)+y(:,2)/86400;
pos2=y(:,3:5);
vel2=y(:,6:8);
vel1=zeros(size(pos1));

%-----------------------------------------------%
n1=max(size(t1));

pos2_bar=zeros([n1,3]);
vel2_bar=zeros([n1,3]);

tanf=min(t2);
steps=median(diff(t2));
steps=round(86400*steps);
s1=round(86400*(t1-tanf));

for j1=1:n1
   pos2_bar(j1,:) = evfxob(0,steps,s1(j1)-u(j1),pos2);
   vel2_bar(j1,:) = evfxob(0,steps,s1(j1)-u(j1),vel2);
endfor
r2_bar=pos2_bar(:,1).^2+pos2_bar(:,2).^2+pos2_bar(:,3).^2;
jj=find(r2_bar~=0);
%-----------------------------------------------%

%gset xlabel 'epoch time [jd2000/days]'
%gset ylabel 'difference [m]'

[t,R,X,A,dR,dX,dA,i1,i2] = posvel12_2_RXA(...
      t1(jj),pos1(jj,:),    vel1(jj,:),...
      t1(jj),pos2_bar(jj,:),vel2_bar(jj,:));

%gset terminal postscript
%gset term post landscape color "Times-Roman" 14
%gset nokey

s=zeros(size(t));
for k=1:3
   s=s+(pos1(jj,k)-pos2_bar(jj,k)).^2;
endfor
s=sqrt(s);

%--------------------------------
fid=fopen('tRXA_3D','w');
fprintf(fid,"%20.13e %20.13e %20.13e %20.13e %20.13e\n",[t R X A s]');
fclose(fid);
%--------------------------------

%----------------------------
RMS_R=sqrt(sum(R.^2)/max(size(R)));
RMS_X=sqrt(sum(X.^2)/max(size(X)));
RMS_A=sqrt(sum(A.^2)/max(size(A)));
RMS_s=sqrt(sum(s.^2)/max(size(s)));
printf("251021 220000 : QUALCO RMS_GeomOrb_Diff  radial = %4.1f mm,...
 along-track = %4.1f mm,...
 cross-track = %4.1f mm,...
 3D = %4.1f mm, nepoch = %d\n",...
    1000*RMS_R, 1000*RMS_A, 1000*RMS_X, 1000*RMS_s, max(size(R)));
printf("251021 220000 : QUALCO Mean_GeomOrb_Diff radial = %4.1f mm,...
 along-track = %4.1f mm,...
 cross-track = %4.1f mm,...
 nepoch = %d\n",...
    1000*mean(R), 1000*mean(A), 1000*mean(X), max(size(R)));
%----------------------------

#rxa_form ='@36' ;
#d3_form  ='@24' ;

%gset output 'xx.ps'
%gset title 'a0 dynamic vs. geometric orbit : 3d coordinate differences'
%plot(t,s,d3_form)
%gset output 'rxa_residuals_4'
%replot

%gset yrange [-1:1]

%gset output 'xx.ps'
%gset title 'a0 dynamic vs. geometric orbit : radial difference'
%plot(t,R,rxa_form)
%gset output 'rxa_residuals_1'
%replot

%gset output 'xx.ps'
%gset title 'a0 dynamic vs. geometric orbit : cross-track difference'
%plot(t,X,rxa_form)
%gset output 'rxa_residuals_2'
%replot

%gset output 'xx.ps'
%gset title 'a0 dynamic vs. geometric orbit : along-track difference'
%plot(t,A,rxa_form)
%gset output 'rxa_residuals_3'
%replot
